/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws;

import filenet.vw.api.VWWorkflowSignature;
import java.util.Date;

public class VWWSWorkflow {
    private String m_className = "VWWSWorkflow";
    private String m_workflowName = null;
    private VWWorkflowSignature m_signature = null;
    private boolean m_selected = false;

    public VWWSWorkflow(String name) {
        this.m_workflowName = name;
    }

    public VWWSWorkflow(VWWorkflowSignature signature) {
        this.m_signature = signature;
        if (signature != null) {
            this.m_workflowName = signature.getName();
        }
    }

    public String getName() {
        return this.m_workflowName;
    }

    public VWWorkflowSignature getWorkflowSignature() {
        return this.m_signature;
    }

    public String getDescription() {
        if (this.m_signature != null) {
            return this.m_signature.getDescription();
        }
        return null;
    }

    public Date getTimestamp() {
        if (this.m_signature != null) {
            return this.m_signature.getTransferDateTime();
        }
        return null;
    }

    public int getWorkspaceId() {
        if (this.m_signature != null) {
            return this.m_signature.getWorkspaceId();
        }
        return 0;
    }

    public String getPartnerLinks() {
        String[] partnerLinks;
        if (this.m_signature != null && (partnerLinks = this.m_signature.getPartnerlinkNames()) != null && partnerLinks.length > 0) {
            String s = new String();
            for (int i = 0; i < partnerLinks.length; ++i) {
                if (i != 0) {
                    s = s + "\n";
                }
                s = s + partnerLinks[i];
            }
            return s;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public void setSelected(boolean bSelected) {
        this.m_selected = bSelected;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   27 Apr 2005 09:21:42  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.13  $";
    }
}

